
#include <QApplication>

#include "qextserialport.h"

#ifdef Q_WS_WIN
#define PORTNAME1 "COM1"
#define PORTNAME2 "COM2"
#else
#define PORTNAME1 "/dev/ttyS0"
#define PORTNAME2 "/dev/ttyS1"
#endif

bool ConstructorDestructorTest()
{
	bool result = FALSE;

	qDebug("ConstructorDestructorTest");
	qDebug("-------------------------");

	QextSerialPort sp;
	qDebug("+++ Created");

	if( ! sp.open() )
	{
		qDebug("+++ Could not open");

		sp.setName(PORTNAME1);
		if( PORTNAME1 == sp.name() )
		{
			qDebug("+++ set port name");

			if( sp.open() )
			{
				qDebug("+++ Opened");
				sp.close();
				qDebug("+++ Closed");
				result = TRUE;
			} else {
				qDebug("--- Could not open");
			}
		} else {
			qDebug("--- failed to set port name");
		}
	} else {
		qDebug("--- Opened");
		sp.close();
		qDebug("+++ Closed");
	}

	return result;
}

bool WriteDataReadDataTest()
{
	bool result = FALSE;

	qDebug("WriteDataReadDataTest");
	qDebug("---------------------");

	QextSerialPort sp1(PORTNAME1);
	qDebug("+++ Created first");
	QextSerialPort sp2(PORTNAME2);
	qDebug("+++ Created second");

	if( sp1.open() )
	{
		qDebug("+++ Opened first");

		if( sp2.open() )
		{
			qDebug("+++ Opened second");

			char data[] = { 0x00, 0x7F, 0x80, 0xFF };
			if( sp1.writeData( data, 4 ) == 4 )
			{
				qDebug("+++ Transmitted");

				char r_data[] = { 0x00, 0x00, 0x00, 0x00 };
				while( sp2.bytesAvailable() < 4 );
				if( 4 == sp2.readData( r_data, 4)
					&& (uchar)r_data[0] == 0x00
					&& (uchar)r_data[1] == 0x7F
					&& (uchar)r_data[2] == 0x80
					&& (uchar)r_data[3] == 0xFF )
				{
					qDebug("+++ Received");
					result = TRUE;
				} else {
					qDebug("--- Could not receive");
				}
			} else {
				qDebug("--- Could not transmit");
			}
		} else {
			qDebug("--- Could not open second");
		}

		sp1.close();
		qDebug("+++ Closed first");
		sp2.close();
		qDebug("+++ Closed second");
	} else {
		qDebug("--- Could not open first");
	}

	return result;
}

bool WriteReadTest()
{
	bool result = FALSE;

	qDebug("WriteReadTest");
	qDebug("-------------");

	QextSerialPort sp1(PORTNAME1);
	qDebug("+++ Created first");
	QextSerialPort sp2(PORTNAME2);
	qDebug("+++ Created second");

	if( sp1.open() )
	{
		qDebug("+++ Opened first");

		if( sp2.open() )
		{
			qDebug("+++ Opened second");

			char data[] = { 0x00, 0x7F, 0x80, 0xFF };
			if( sp1.write( data, 4 ) == 4 )
			{
				qDebug("+++ Transmitted");

				char r_data[] = { 0x00, 0x00, 0x00, 0x00 };
				while( sp2.bytesAvailable() < 4 );
				if( 4 == sp2.read( r_data, 4)
					&& (uchar)r_data[0] == 0x00
					&& (uchar)r_data[1] == 0x7F
					&& (uchar)r_data[2] == 0x80
					&& (uchar)r_data[3] == 0xFF )
				{
					qDebug("+++ Received");
					result = TRUE;
				} else {
					qDebug("--- Could not receive");
				}
			} else {
				qDebug("--- Could not transmit");
			}
		} else {
			qDebug("--- Could not open second");
		}

		sp1.close();
		qDebug("+++ Closed first");
		sp2.close();
		qDebug("+++ Closed second");
	} else {
		qDebug("--- Could not open first");
	}

	return result;
}

bool WriteReadByteArrayTest()
{
	bool result = FALSE;

	qDebug("WriteReadByteArrayTest");
	qDebug("----------------------");

	QextSerialPort sp1(PORTNAME1);
	qDebug("+++ Created first");
	QextSerialPort sp2(PORTNAME2);
	qDebug("+++ Created second");

	if( sp1.open() )
	{
		qDebug("+++ Opened first");

		if( sp2.open() )
		{
			qDebug("+++ Opened second");

			char data[] = { 0x00, 0x7F, 0x80, 0xFF };
			if( sp1.write( data, 4 ) == 4 )
			{
				qDebug("+++ Transmitted");

				while( sp2.bytesAvailable() < 4 );
				QByteArray buffer;
				buffer += sp2.read(4);
				if( 4 == buffer.size()
					&& (uchar)buffer.at(0) == 0x00
					&& (uchar)buffer.at(1) == 0x7F
					&& (uchar)buffer.at(2) == 0x80
					&& (uchar)buffer.at(3) == 0xFF )
				{
					qDebug("+++ Received %d", (int)sp2.bytesAvailable());
					result = TRUE;
				} else {
					qDebug("--- Could not receive");
				}
			} else {
				qDebug("--- Could not transmit");
			}
		} else {
			qDebug("--- Could not open second");
		}

		sp1.close();
		qDebug("+++ Closed first");
		sp2.close();
		qDebug("+++ Closed second");
	} else {
		qDebug("--- Could not open first");
	}

	return result;
}

bool PutCharGetCharTest()
{
	bool result = FALSE;

	qDebug("PutCharGetCharTest");
	qDebug("--------------");

	QextSerialPort sp1(PORTNAME1);
	qDebug("+++ Created first");
	QextSerialPort sp2(PORTNAME2);
	qDebug("+++ Created second");

	if( sp1.open() )
	{
		qDebug("+++ Opened first");

		if( sp2.open() )
		{
			qDebug("+++ Opened second");

			if( sp1.putChar( 0x00 )
				&& sp1.putChar( 0x7F )
				&& sp1.putChar( 0x80 )
				&& sp1.putChar( 0xFF ) )
			{
				qDebug("+++ Transmitted");

				while( sp2.bytesAvailable() < 4 );
				char chars[4];
				if( sp2.getChar( chars )
					&& sp2.getChar( chars+1 )
					&& sp2.getChar( chars+2 )
					&& sp2.getChar( chars+3 ) )
				{
					if( 0x00 == (uchar)chars[0]
						&& 0x7F == (uchar)chars[1]
						&& 0x80 == (uchar)chars[2]
						&& 0xFF == (uchar)chars[3] )
					{
						qDebug("+++ Received");
						result = TRUE;
					} else {
						qDebug("--- Received wrong chars");
					}
				} else {
					qDebug("--- Could not get chars");
				}
			} else {
				qDebug("--- Could not transmit");
			}
		} else {
			qDebug("--- Could not open second");
		}

		sp1.close();
		qDebug("+++ Closed first");
		sp2.close();
		qDebug("+++ Closed second");
	} else {
		qDebug("--- Could not open first");
	}

	return result;
}
/*
bool PutchUngetchGetchTest()
{
	bool result = FALSE;

	qDebug("PutchUngetchGetchTest");
	qDebug("---------------------");

	QextSerialPort sp1(PORTNAME1);
	qDebug("+++ Created first");
	QextSerialPort sp2(PORTNAME2);
	qDebug("+++ Created second");

	if( sp1.open() )
	{
		qDebug("+++ Opened first");

		if( sp2.open() )
		{
			qDebug("+++ Opened second");

			if( sp1.putChar( 0x00 ) == 0x00
				&& sp1.putChar( 0x7F ) == 0x7F
				&& sp1.putChar( 0x80 ) == 0x80
				&& sp1.putChar( 0xFF ) == 0xFF )
			{
				qDebug("+++ Transmitted");

				while( sp2.bytesAvailable() < 4 );
				if( 0x00 == (uchar)sp2.getch()
					&& 0x7F == (uchar)sp2.getch()
					&& 0x80 == (uchar)sp2.getch() )
				{
					qDebug("+++ Received");

					if( 0x80 == sp2.ungetch( 0x80 )
						&& 0x7F == sp2.ungetch( 0x7F )
						&& sp2.size() == 3 )
					{
						qDebug("+++ Ungotten");

						if( 0x7F == (uchar)sp2.getch()
							&& 0x80 == (uchar)sp2.getch()
							&& 0xFF == (uchar)sp2.getch() )
						{
							qDebug("+++ Received");
							result = TRUE;
						} else {
							qDebug("--- Could not receive");
						}
					} else {
						qDebug("--- Could not unget");
					}
				} else {
					qDebug("--- Could not receive");
				}
			} else {
				qDebug("--- Could not transmit");
			}
		} else {
			qDebug("--- Could not open second");
		}

		sp1.close();
		qDebug("+++ Closed first");
		sp2.close();
		qDebug("+++ Closed second");
	} else {
		qDebug("--- Could not open first");
	}

	return result;
}

bool ReadLineTest()
{
	bool result = FALSE;

	qDebug("ReadLineTest");
	qDebug("------------");

	QextSerialPort sp1(PORTNAME1);
	qDebug("+++ Created first");
	QextSerialPort sp2(PORTNAME2);
	qDebug("+++ Created second");

	if( sp1.open() )
	{
		qDebug("+++ Opened first");

		if( sp2.open() )
		{
			qDebug("+++ Opened second");

			char data[] = { 0x00, 0x7F, 0x0A, 0xFF, 0x00, 0x0D, 0x7F, 0x80, 0xFF };
			if( sp1.writeBlock( data, 8 ) == 8 )
			{
				qDebug("+++ Transmitted");

				char r_data[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0xAB };
				while( sp2.bytesAvailable() < 8 );
				if( 4 == sp2.readLine( r_data, 5 )
					&& (uchar)r_data[0] == 0x00
					&& (uchar)r_data[1] == 0x7F
					&& (uchar)r_data[2] == 0x0A
					&& (uchar)r_data[3] == 0x00
				 && 6 == sp2.readLine( r_data, 6 )
					&& (uchar)r_data[0] == 0xFF
					&& (uchar)r_data[1] == 0x00
					&& (uchar)r_data[2] == 0x0D
					&& (uchar)r_data[3] == 0x7F
					&& (uchar)r_data[4] == 0x80
					&& (uchar)r_data[5] == 0x00 )
				{
					qDebug("+++ Received");
					result = TRUE;
				} else {
					qDebug("--- Could not receive");
				}
			} else {
				qDebug("--- Could not transmit");
			}
		} else {
			qDebug("--- Could not open second");
		}

		sp1.close();
		qDebug("+++ Closed first");
		sp2.close();
		qDebug("+++ Closed second");
	} else {
		qDebug("--- Could not open first");
	}

	return result;
}

bool ReadAllTest()
{
	bool result = FALSE;

	qDebug("ReadAllTest");
	qDebug("-----------");

	QextSerialPort sp1(PORTNAME1);
	qDebug("+++ Created first");
	QextSerialPort sp2(PORTNAME2);
	qDebug("+++ Created second");

	if( sp1.open() )
	{
		qDebug("+++ Opened first");

		if( sp2.open() )
		{
			qDebug("+++ Opened second");

			char data[] = { 0x00, 0x7F, 0x80, 0xFF };
			if( sp1.writeBlock( data, 4 ) == 4 )
			{
				qDebug("+++ Transmitted");

				QByteArray ba( 4 );
				*(ba.data()) = 0x00;
				*(ba.data()+1) = 0x7F;
				*(ba.data()+2) = 0x80;
				*(ba.data()+3) = 0xFF;
				while( sp2.bytesAvailable() < 4 );
				if( sp2.readAll() == ba )
				{
					qDebug("+++ Received");
					result = TRUE;
				} else {
					qDebug("--- Could not receive");
				}
			} else {
				qDebug("--- Could not transmit");
			}
		} else {
			qDebug("--- Could not open second");
		}

		sp1.close();
		qDebug("+++ Closed first");
		sp2.close();
		qDebug("+++ Closed second");
	} else {
		qDebug("--- Could not open first");
	}

	return result;
}

bool RtsCtsTest()
{
	bool result = FALSE;

	qDebug("RtsCtsTest");
	qDebug("----------");

	QextSerialPort sp1(PORTNAME1);
	qDebug("+++ Created first");
	QextSerialPort sp2(PORTNAME2);
	qDebug("+++ Created second");

	if( sp1.open() )
	{
		qDebug("+++ Opened first");

		if( sp2.open() )
		{
			qDebug("+++ Opened second");

			if( sp2.cts() == TRUE )
			{
				qDebug("+++ state is TRUE");

				sp1.setRts( FALSE );
				if( sp2.cts() == FALSE )
				{
					qDebug("+++ state is FALSE");
					result = TRUE;
				} else {
					qDebug("--- state is TRUE");
				}
			} else {
				qDebug("--- state is FALSE");
			}
		} else {
			qDebug("--- Could not open second");
		}

		sp1.close();
		qDebug("+++ Closed first");
		sp2.close();
		qDebug("+++ Closed second");
	} else {
		qDebug("--- Could not open first");
	}

	return result;
}

bool DtrDcdTest()
{
	bool result = FALSE;

	qDebug("DtrDcdTest");
	qDebug("----------");

	QextSerialPort sp1(PORTNAME1);
	qDebug("+++ Created first");
	QextSerialPort sp2(PORTNAME2);
	qDebug("+++ Created second");

	if( sp1.open() )
	{
		qDebug("+++ Opened first");

		if( sp2.open() )
		{
			qDebug("+++ Opened second");

			if( sp2.dcd() == TRUE )
			{
				qDebug("+++ state is TRUE");

				sp1.setDtr( FALSE );
				if( sp2.dcd() == FALSE )
				{
					qDebug("+++ state is FALSE");
					result = TRUE;
				} else {
					qDebug("--- state is TRUE");
				}
			} else {
				qDebug("--- state is FALSE");
			}
		} else {
			qDebug("--- Could not open second");
		}

		sp1.close();
		qDebug("+++ Closed first");
		sp2.close();
		qDebug("+++ Closed second");
	} else {
		qDebug("--- Could not open first");
	}

	return result;
}
*/
int main( int argc, char* argv[] )
{
	QApplication app( argc, argv );

	bool ok = TRUE;
/*
	if( ok ) {
		qDebug("\n");
		ok = ConstructorDestructorTest();
	}

	if( ok ) {
		qDebug("\n");
		ok = WriteDataReadDataTest();
	}

	if( ok ) {
		qDebug("\n");
		ok = WriteReadTest();
	}
*/
	if( ok ) {
		qDebug("\n");
		ok = WriteReadByteArrayTest();
	}
/*
	if( ok ) {
		qDebug("\n");
		ok = PutCharGetCharTest();
	}

	if( ok ) {
		qDebug("\n");
		ok = PutchUngetchGetchTest();
	}

	if( ok ) {
		qDebug("\n");
		ok = ReadLineTest();
	}

	if( ok ) {
		qDebug("\n");
		ok = ReadAllTest();
	}

	if( ok ) {
		qDebug("\n");
		ok = RtsCtsTest();
	}

	if( ok ) {
		qDebug("\n");
		ok = DtrDcdTest();
	}
*/
	if( ok )
		qDebug("\n!!!   All tests were Ok   !!!\n");
	else
		qDebug("\n!!!   Tests failed   !!!\n");
}
