
#include <qapplication.h>

#include "qextserialport.h"

#ifdef Q_WS_WIN
#define PORTNAME1 "COM1"
#define PORTNAME2 "COM2"
#else
#define PORTNAME1 "/dev/ttyS0"
#define PORTNAME2 "/dev/ttyS1"
#endif

class MySerialPort
 : public QextSerialPort
{
public:
	MySerialPort( const QString& name = "" );
	virtual ~MySerialPort();

//	virtual void setBaudRate( BaudRateType );
//	virtual void setDataBits( DataBitsType );
//	virtual void setStopBits( StopBitsType );
	virtual void setParity( ParityType );
};

MySerialPort::MySerialPort( const QString& name )
 : QextSerialPort( name )
{
}

MySerialPort::~MySerialPort()
{
}

void MySerialPort::setParity( ParityType parity )
{
	if( Settings.Parity != parity )
	{
		Settings.Parity = parity;
	}

	if( isOpen() )
	{
#ifdef Q_WS_WIN
		switch ( parity ) {
			/*space parity*/
			case QextSerialPort::PAR_SPACE:
				if( Settings.DataBits == DATA_8 )
				{
					/* TTY_PORTABILITY_WARNING("Win_QextSerialPort
					 Portability Warning: Space parity with 8 data bits
					 is not supported by POSIX systems."); */
				}
				Win_CommConfig.dcb.fParity=TRUE;
				break;

			default:
				QextSerialPort::setParity( parity );
		}
		SetCommState( Win_Handle, &Win_CommConfig );
#else
		switch ( parity ) {
			/*space parity*/
			case QextSerialPort::PAR_SPACE:
				if( Settings.DataBits == QextSerialPort::DATA_8 )
				{
					/* TTY_PORTABILITY_WARNING("Posix_QextSerialPort:
					 Space parity is only supported in POSIX
					 with 7 or fewer data bits"); */
				} else {
					/* space parity not directly supported
					 - add an extra data bit to simulate it !!! */
					Posix_CommConfig.c_cflag &= ~(PARENB|CSIZE);
					switch( Settings.DataBits ) {
						case QextSerialPort::DATA_5:
							Settings.DataBits = QextSerialPort::DATA_6;
							Posix_CommConfig.c_cflag |= CS6;
							break;

						case QextSerialPort::DATA_6:
							Settings.DataBits = QextSerialPort::DATA_7;
							Posix_CommConfig.c_cflag |= CS7;
							break;

						case QextSerialPort::DATA_7:
							Settings.DataBits = QextSerialPort::DATA_8;
							Posix_CommConfig.c_cflag |= CS8;
							break;
					}
					tcsetattr( Posix_File->handle(), TCSAFLUSH, &Posix_CommConfig );
				}
				break;

			default:
				QextSerialPort::setParity( parity );
		}
		tcsetattr( Posix_File->handle(), TCSAFLUSH, &Posix_CommConfig );
#endif
	}
}

int main( int argc, char* argv[] )
{
	QApplication app( argc, argv );

	MySerialPort sp1(PORTNAME1);
	MySerialPort sp2(PORTNAME1);

	sp1.open();
	sp1.setParity( QextSerialPort::PAR_SPACE );
	sp2.open();
	sp2.setParity( QextSerialPort::PAR_NONE );

	//return app.exec();
}
