
/*!
    \mainpage

    Aspect is a simple PEC tool.

    - \ref userdoc
    - \ref changelog
    - <a href="http://www.woho.de/devel/astro/aspect.html" target="_blank">Aspect Website</a>
*/

/*!
    \page userdoc Aspect User Documentation


    \section purpose Purpose

    Aspect was created to semi-automate the process of teaching PEC (periodic
    error correction) for Rajiva's
    <a href="http://eq6.update.rajiva.de/" target="_blank">EQ6/HEQ5 MCU Upgrade kit</a>
    and the
    <a href="http://littlefoot.rajiva.de/" target="_blank">LittleFoot</a>
    astronomical mount stepper controler.

    From v0.4 on, Aspect's basic functionality is there.
    It's quite sparsely tested, however, and bears a lot of
    assumptions from my side on how PEC is implemented in the LittleFoot firmware.
    And there are some rough edges usability wise, for sure.
    See the \ref changelog for current state.

    Many thanks to the friendly people at the
    <a href="http://forum.rajiva.de/" target="_blank">LittleFoot support forum</a>
    who contributed to this project, especially Rajiva, Doug and Christian.


    \section prepare Preparations

    You need
    - a serial connection to the LittleFoot/MCU
    - Doug Dieter's
        <a href="http://mcucontrol.dyndns.org/MCUControlPlus/" target="_blank">MCU Control Plus</a>,
        version 2.1.7 or higher (2.1.4 won't work, as it lacks the required logging feature
        while followin a star)
    - a webcam that could be used for autoguiding with MCU Control Plus<br>
        you don't need a guiding scope, you can use your main optics for
        measuring
    - clear skies


    \section quickguide Quick Guide

    This is a minimal description of the workflow, you might want to read
    the more verbose \ref walkthrough first (as soon as its written ...).

    - Set PEC off and measure PE for at least one cycle in MCU Control Plus
        - Choose a guide star close to the celestial equator and far away from
            the horizon, if possible. Remember the guide star's declination.
    - Generate a PEC table in Aspect:
        - tab \c MCU :
            - choose serial port, and press "refresh" to see if communication is ok<br>
                in case of problems, check the MCU log window (accessable from menu "Help")
        - tab <tt>PE Raw Data</tt>:
            - import PE file
        - tab <tt>PE Processing</tt>:
            - set \c Smoothing \c Width to eliminate seeing and short jumps
            - set \c First \c Sample and \c Last \c Sample to cut away bad samples
                at the beginning and/or end of measurement
            - set \c Star \c Dec to the declination of the guide star you used
                while measuring with MCU Control Plus
            - play with \c Drift so that cycles match as good as possible
            - set \c Scale to \c -1 if PE doubles with PEC, i.e. PEC makes things
                worse instead of better
        - tab <tt>PEC Table</tt>:
            - set \c PEC \c Factor to \c 1 ; Aspect so far is testet with value \c 1 only
            - set \c Worm \c Wheel \c Teeth to what's apropriate for your mount;
                optionally query from the MCU by pressing the \c Query button
            - leave \c PEC \c Table \c Traversal and \c PEC \c Acceleration as is for now
            - press the <tt>Calculate PEC from PE</tt> button
            - play with the \c Graph \c Offset to see how well or bad PE and the
                generated PEC match; maybe switch away the \c Raw \c PE graph with
                the checkbox below the chart area
            - upload the PEC table to the MCU by pressing the \c Put button, or
                save it to a file with <tt>Save As</tt> and restore it with MCU Control Plus

    Optionally do a dry run to verify if the generated PEC table makes the MCU moves
    the worm as intended, to get the required position profile for compensating the PE:
    - in Aspect:
        - tab <tt>PEC Profile</tt>:
            - maybe adjust \c Polling \c Interval (a poll every 0.5 seconds work fine for me,
                but 2 or 3 seconds should do as well)
            - press \c Start <br>
                \b Attention: this sets tracking speed to Sidereal and switches off IntellyTrack.
            - let run for at least one cycle
            - press \c Stop
            - adjust \c Graph \c Drift to make the purple graph run into it's beginning at the
                end of the first cycle; all cycles should match then.
            - use \c Graph \c Offset to move the purple PEC Profile graph match the green PEC
                graph as good as possible
        - if peak-to-valley of purple and green graph differ, reiterate PEC generation:<br>
            tab <tt>PEC Table</tt>:
            - adjust \c PEC \c Acceleration such that green and purple graph span same amplitude
            - press the <tt>Calculate PEC from PE</tt> button
            - upload PEC table to MCU and do another PEC profile run

    Now verify how good/bad the generated PEC table works under the sky:
    - Set PEC to on and redo measuring PE for at least one cycle in MCU Control Plus
        (select a different PEC log file than before, as this is the result of PE correction now)
    - Load PEC log into aspect
        - drift-compensate, scale and smooth as above
        - the resulting red graph ideally should become a flat horizontal line; you
            can read the remaining PE in arcseconds from the left scale (peak-to-valley; absolute
            values are not relevant)


    \section walkthrough Walkthrough

    \todo Write this ...

*/

/*

    \section walkthrough Walkthrough

    \subsection walkthrough_aqui PE data aquisition

    First you need to measure the PE (periodical error) of your mount.

    Currently there are two import filters in Aspect:
    - <a href="http://www.astrosurf.org/buil/iris/lecon24_us.htm" target="_blank">IRIS</a>:<br>
        Proceed as described at the above link, at the last quarter of the page.
        This method has a major drawback, as there is no recording of the
        worm wheel positions corresponding to the measured error values.<br>
        This is deprecated.
    - <a href="http://www.kennaquhair.com/MCUControlPlus/">MCU Control Plus</a><br>
        Currently, you need a beta version that has the PEC logging feature
        in the video/autoguiding module, see \ref prepare. <br>
        This is the recommended way.

    \todo Describe data aquisition with MCU Control Plus


    \subsection walkthrough_mcu MCU Settings

    Now launch Aspect and start out at the \c MCU tab:
    \image html screenshot-tab-mcu-v0.3.png "Tab MCU Settings"

    Set the port to where the MCU is attached by choosing one entry from the
    \c Serial \c port dropdown or entering a portname into it (click on the text
    to edit). On Linux you can also enter a full device name, e.g. \c /dev/ttyS0

    Currently connection is opened only on demand, and closed immediately after
    finishing the particular communication (e.g. open port, get PEC table, close
    port). The toggle button \c Autoconnect is hardcoded permanently checked,
    an explicit connect/disconnect functionality might be implemented later.

    To check if the communication is ok, press the \c Refresh button to query
    the current settings.

    For debugging, you might manually enter a raw command into the \c Command
    textfield at the bottom, and press \c Send to submit it to the MCU. The
    resulting answer is shown in the \c Answer textfield.
    \b Warning: unless you know what you're doing, don't use this. This is a
    low level access into the MCU. You might screw up your settings if entering
    random commands here.


    \subsection walkthrough_peraw PE Raw Data Import

*/


/*!
    \page todos Aspect Todos

    \todo fix: add German translation

    \todo fix: with v4, PEC is off after switching e.g. on by handbox and
        off via serial (and vice versa)

    \todo feature: display content of logfiles in Tool->Log Files menu

    \todo feature: add further indicators to status bar:
        - MCU:
            - LED indicating PEC status
                - clear: unknown
                - red, off: not ok
                - green, off: ok, off
                - red, on: ok, on by handbox
                - yellow, on: ok, on by serial
                - green, on: ok, in training
        - PE file:
            - filename
            - LED on if following
        - PEC:
            - filename ("from MCU" after get, "generated" after calc)
            - LED indicating PEC table sync:
                - clear if PEC table sync unknown
                - green if in sync (after get, put)
                - yellow if out of sync (after load, calc)

    \todo feature: add third mode "Resync" to "Normal" and "Touchup"
        that keeps the shape and amplitude of a given PEC table, but
        moves it sidewards so that it fits the current measurement best
        (for recovering after getting worm-position out of sync)

    \todo feature: improve drift compensation:
        - automatically determine drift by comparing samples at same
            PEC point of different periods
        - maybe enhance compensation to model a non-linear drift (e.g. by
            using a gliding average over one half period?)

    \todo feature: add "Normal" and "Experimental" GUI mode, with "Standard"
        hiding all experimental and debuggin features (PEC profiling)
        and presenting empirical values (PEC accelereation, PEC factor, ...)
        as read-only

    \todo fix: add error message boxes to Tools->Mount dialog

    \todo improvement: fix PEC profile tab:
        - find out why using the guiding button commands in parallel with
            PEC status polling breaks the latter and fix it
            (workaround a la mcuSetIntelly()?)
*/


/*!
    \page changelog Aspect Changelog

    \section v0801 Aspect 0.8.1 (24 Mar 2007)

    - bugfixes:
        - fix problems with MCU communication on Windows
          by modifying the way QExtSerialPort handles timeouts:
            - performance was bad when e.g. getting PEC table
            - PEC profiling did hang with a polling rate of 0.5 seconds
        - fix crash with PE curves with large discontinuities and/or
            extremely steep jumps (resulting in untraversable PE graph)
    - improvements:
        - reduce overhead when starting MCU communication:
            send an ACK instead of always querying the firmware version
        - PEC profiling: query worm wheel teeth from MCU when starting
        - show firmware version in statusbar
        - tweaks for v4.00 firmware:
            - send multiple store commands when saving settings to EEPROM
            - don't send store command after changing PEC factor/aggressiveness
                as that seems to cause PEC count losses now and then

    \section v08 Aspect 0.8 (10 Mar 2007)

    - new features:
        - support for the upcoming v4.00 firmware:
            - reworked MCU communication to support both firmware v3.59 and v4.00
            - add PEC aggressiveness to PEC model (new in firmware v4)
            - before uploading a PEC table to the MCU, check if it's compatible
                with the firmware that's on the MCU
        - logfiles: introduced two logfiles that keep a history of what happened:
            - aspect_log_xxxxxxxx.txt is a log of all major actions, e.g.
                reading a PE file, PE processing settings and Mount settings
                when generating a PEC table, etc. It's intended to help
                reproduce what has been done lateron, as one easily gets
                lost out in the field with all those parameters and files ...
            - aspect_mcu_xxxxxxxx.txt is a log of all serial communication
                with the LittleFoot/MCU. It's intended for debugging
                serial communication problems (if there are any)
            - logfile location is a temporary path that is reported
                the "Settings" menu.
        - cure "PEC state not OK":
            Before uploading a PEC table to the MCU, check if PEC state is ok.
            If the MCU signals "PEC state not OK", start a minimal dummy PEC
            training to get it back to "PEC state OK", and then upload the
            PEC table.
    - bugfixes:
        - after switching away all graphs, the chart stayed blank forever
    - improvements:
        - PEC generation:
            - widen the target corridor of internal PEC generation graph to avoid
                failing with very steep jumps
            - improve accuracy of PE compensation:
                base PEC calculation on inverse of PE measurement, not on negative PE.
                This might help fine-tuning PE with high amplitude. A new graph
                "Ideal PEC" is introduced which, when compared to "Processed PE",
                shows the difference (marginal in most cases).
        - usability:
            - added a lot of sanity checks to report errors with message boxes
            - status bar has a status indicator for the serial communication
            - add a "Settings" dialog and moved some rather internal parameters to there
            - file dialogs now keep a history of previously used paths
            - make configuration persistent over application restarts

    \section v07 Aspect 0.7 (04 Feb 2007)

    - new features:
        - reworked the PEC model to use PEC factors higher than 1, if needed
        - reworked PEC table generation to take a more global approach.
            The previous model just moved from one PEC point to the next,
            resulting in sub-optimal PEC tables when PE has sharp jumps.
            Now a complete view of the whole period is used to minimize the
            overall square error. This is especially necessary for taking
            good advantage of higher PEC factors. Generation takes more than
            an instant of time now, so show a progress bar.
        - added a PEC touch-up mode to the PEC Processing tab. To use it,
            upload your favorite PEC table to the MCU and load/get it into Aspect.
            Switch PEC on and do a PE measurement with MCU Control Plus.
            Load the resulting PE log file into Aspect, select PEC mode
            "Touchup" and generate an new PEC table, which hopefully is
            even better than your previous favorite.
    - bugfixes:
        - setting the PEC factor was badly broken. It needs to be
            sent before PEC table to make the MCU actually use it.
            So changing the PEC factor and pressing the button
            "Put PEC table" now works.
        - when smoothing data with gaps (measurement period greater than
            one pec point), some processed PE values were stuck at 0.
            fixed that, problem was introduced with v0.6
        - changed sign of PE. positive PE values mean moving too fast
            (drifting westwards), PEC generation now gets that right.
        - switch off PE file monitoring when opening a new PE file
    - improvements:
        - reworked serial communication to allow asynchronous command
            and answer handling. Use this to speed up "Get PEC table"
            by asynchronously sending/receiving the individual PEC values
            from MCU, as Doug does in MCU Plus

    \section v06 Aspect 0.6 (27 Jan 2007)

    - new features:
        - tab "PE Processing": add fields for entering a data range
            to cut away bad samples at begin and/or end of measurement
        - tab "PE Raw Data": add "Follow" button. When toggled, the
            chosen file is monitored for further data being appended,
            with the PE graph being updated in realtime. You can use
            this to watch data come in during measurement with
            MCU Control Plus.
    - bugfixes:
        - limiting chart axis scales to 300 arcsecs to
            properly cope with huge values in chart (don't draw thousands
            of grid lines, makes Aspect appear to hang)
        - if opening the serial port failed, all GUI elements that
            potentially lead to communication with the MCU were stuck
            disabled. fixed that, problem was introduced with v0.4
    - improvements:
        - tab "PE Processing": add field for entering guide star declination
        - tab "PE Processing": reworked smoothing, such that to Raw PE graph
            is also affected by smoothing. Intention is to make manual
            drift compensation easier, as the curves of multiple periods are
            hard to match when there is much noise (e.g. due bad seeing)
    - documentation:
        - updated the \ref quickguide to reflect current state

    \section v05 Aspect 0.5 (22 Jan 2007)

    - bugfixes:
        - tab "MCU": fix "PEC" combobox to correctly show current
            PEC status and offer Off/On only if PEC is Off by handbox
            and not in teaching mode
        - tab "PEC Table": replace "RA Rotation" and "Hemisphere" by
            "PEC Table Traversal", defaulting to Backwards, as it seems that
            the PEC table is always traversed with pecByte decrementing,
            regardless of rotation and hemisphere
        - reduce MCU communication log history from 1000 to 40 messages,
            as it seems to hit performance of e.g. PEC table get/put
    - improvements:
        - tab "PEC Profile": widen poll interval range, raise default to 1 second
    - hacks:
        - tab "PEC Profile": default Graph Drift to -2.6 arcsecs/period, as that
            drift seems to be a general phaenomen. It's reason is still unclear.

    \section v04 Aspect 0.4 (21 Jan 2007)

    - new features:
        - load/save PEC profile measurements
        - add MCU communication log for troubleshooting
    - improvements:
        - improve directory handling:
            remember the last visited directory and set as default in
            file dialogs (before always the home directory was set,
            which gets pretty annoying with deep directory hierarchies)
        - disable buttons that might cause MCU communication if a MCU
            communication block is started
        - PEC profile tab: better button feedback (use toggles; disable unusable buttons)
    - bugfixes:
        - write PEC table files with line terminator depending on platform:
            the last fix of v0.3 broke writing from Windows
        - PEC profile measurement: remove hardcoded 144 worm wheel teeth (oops)
    - experimental/internal:
        - move east/west (at guide rate) during PEC profile measurements<br>
            note: PEC profiling has to be paused for starting/stoping movement.

    \section v03 Aspect 0.3 (14 Jan 2007)

    - new features:
        - generate PEC tables
        - measure resulting PEC profile
        - added user documentation fragments
    - bugfixes:
        - write PEC table files with CR/LF as line terminator,
            otherwise MCU Control Plus can't read them
        - add timeouts at serial communication to avoid hanging the application
            if no LittleFoot/MCU is connected
        - fix default file paths to be common locations

    \section v02 Aspect 0.2 (06 Jan 2007)

    - new features:
        - import PE data from Doug Dieter's 
            <a href="http://mcucontrol.dyndns.org/MCUControlPlus/" target="_blank">MCU Control Plus</a>
        - get and put PEC tables from/to LittleFoot
        - communication with LittleFoot via serial line basically works

    \section v01 Aspect 0.1 (02 Jan 2007)

    - initial release:
        - read and write PEC tables from/to .csv files
        - read PE output from
            <a href="http://www.astrosurf.org/buil/iris/lecon24_us.htm" target="_blank">IRIS</a>
        - edit and chart PE and PEC

*/