
/***************************************************************************
 *   This file is part of Aspect, a simple PEC tool.                       *
 *                                                                         *
 *   Copyright (C) 2007 by Wolfgang Hoffmann <woho@woho.de>                *
 *                                                                         *
 *   This program is free software, licensed under the GPL v2.             *
 *   See the file COPYING for more details.                                *
 ***************************************************************************/


#ifndef ASPECT_SETTINGS_H
#define ASPECT_SETTINGS_H


#include <QDialog>
#include <QSettings>
#include <QString>
#include <QStringList>


namespace Ui { class SettingsDialog; };


class Settings: public QObject
    {
    Q_OBJECT

public:
    ~Settings();

    static QSettings &settings() { return *(g_oSettings.m_pQSettings); };

    static void connect(QObject *pReceiver, const char *szSlot);
    static void freeze();
    static void thaw();

    static QString getPathLog();
    static void setPathLog(const QString &qsPath);
    static QStringList getPathHistory();
    static QString getPathDefault();
    static void setPathDefault(const QString &qsPath);

    static bool getLoggingGeneral();
    static void setLoggingGeneral(bool bOn);
    static bool getLoggingMcu();
    static void setLoggingMcu(bool bOn);

    static QString getMcuPort();
    static void setMcuPort(const QString &qsPort);
    static int getMcuFirmware();
    static void setMcuFirmware(int nFirmware);
    static int getMcuWormWheelTeeth();
    static void setMcuWormWheelTeeth(int nTeeth);

    static int getPecGenTraversal();
    static void setPecGenTraversal(int nTraversal);
    static double getPecGenAccel();
    static void setPecGenAccel(double dfAccel);
    static int getPecGenAggressMin();
    static void setPecGenAggressMin(int nAggressMin);
    static int getPecGenAggressMax();
    static void setPecGenAggressMax(int nAggressMax);
    static int getPecGenFactorMax();
    static void setPecGenFactorMax(int nFactorMax);

signals:
    void settingsChanged();

private:
    Settings();
    static void emitChanged();
    void emitChangedInternal(bool bFromChange);

private:
    static Settings g_oSettings;
    QSettings *m_pQSettings;
    bool m_bFrozen;
    bool m_bChanged;
    };


class SettingsDialog: public QDialog
    {
    Q_OBJECT

public:
    SettingsDialog(QWidget *pParent = 0);
    ~SettingsDialog();

public slots:
    void on_logfilesGeneral_clicked();
    void on_logfilesMcu_clicked();
    void on_logfilesPathSelect_clicked();
    void on_pecGenTraversal_activated(int nIndex);
    void on_pecGenAccel_valueChanged(double dfValue);
    void on_pecGenAggressMin_valueChanged(int nValue);
    void on_pecGenAggressMax_valueChanged(int nValue);
    void on_pecGenFactor_valueChanged(int nValue);

private:
    Ui::SettingsDialog *m_pUi;
    };


#endif // ASPECT_SETTINGS_H

