
/***************************************************************************
 *   This file is part of Aspect, a simple PEC tool.                       *
 *                                                                         *
 *   Copyright (C) 2007 by Wolfgang Hoffmann <woho@woho.de>                *
 *                                                                         *
 *   This program is free software, licensed under the GPL v2.             *
 *   See the file COPYING for more details.                                *
 ***************************************************************************/


#ifndef ASPECT_MOUNT_H
#define ASPECT_MOUNT_H


#include <QDialog>
#include <QString>

class McuProxy;


namespace Ui { class MountDialog; };


class MountDialog: public QDialog
    {
    Q_OBJECT

public:
    MountDialog(QWidget *pParent = 0);
    ~MountDialog();

public slots:
    void settingsChanged();
    void mcuSerialBusy(bool bBusy);
    void on_mcuPort_activated(const QString &qsPort);
    void on_mcuFirmwareRefresh_clicked();
    void on_mcuSettingsTracking_activated(int nSpeed);
    void on_mcuSettingsPec_activated(int nIndex);
    void on_mcuSettingsIntelly_activated(int nIndex);
    void on_mcuSettingsRefresh_clicked();
    void on_mcuGearsQuery_clicked();
    void on_mcuGearsSet_clicked();
    void on_mcuCommandSend_clicked();

private:
    bool mcuCommunicationBegin();
    void mcuCommunicationEnd();

private:
    Ui::MountDialog *m_pUi;
    McuProxy *m_pMcuProxy;
    };


#endif // ASPECT_MOUNT_H

