
/***************************************************************************
 *   This file is part of Aspect, a simple PEC tool.                       *
 *                                                                         *
 *   Copyright (C) 2006-2007 by Wolfgang Hoffmann <woho@woho.de>           *
 *                                                                         *
 *   This program is free software, licensed under the GPL v2.             *
 *   See the file COPYING for more details.                                *
 ***************************************************************************/


#ifndef ASPECT_MCUSERIAL_H
#define ASPECT_MCUSERIAL_H


#include <QObject>


class QextSerialPort;
class QString;


class IMcuCmd
    {
public:
    virtual ~IMcuCmd() {};
private:
    virtual QByteArray command() const = 0;
    virtual QString name() const = 0;
friend class McuSerial;
    };

class IMcuAns
    {
public:
    virtual ~IMcuAns() {};
private:
    virtual void receive(int &rnMin, int &rnMax,
        const QByteArray &aAnswerFragment) = 0;
    virtual QString name() const = 0;
friend class McuSerial;
    };

class IMcuCmdAns: public IMcuCmd, public IMcuAns
    {
public:
    virtual ~IMcuCmdAns() {};
    };


class McuSerial : public QObject
    {
    Q_OBJECT

public:
    enum Status { unknown, error, cmd_ok, ans_ok };

    McuSerial();
    virtual ~McuSerial();

    bool open(const QString &qsPort);
    void close();

    bool send(IMcuCmd *pCmd);
    bool recv(IMcuAns *pAns, int nTimeout = 200);
    void flush();

    static void msleep(int nMsecs);

signals:
    void status(bool bOpen, McuSerial::Status eStatus);

private:
    static QString hex(const QByteArray &aData);

private:
    QextSerialPort *m_pSerPort;
    bool m_bOpen;
    Status m_eStatus;
    QString m_qsLastCmd;
    };


#endif // ASPECT_MCUSERIAL_H

