
/***************************************************************************
 *   This file is part of Aspect, a simple PEC tool.                       *
 *                                                                         *
 *   Copyright (C) 2006-2007 by Wolfgang Hoffmann <woho@woho.de>           *
 *                                                                         *
 *   This program is free software, licensed under the GPL v2.             *
 *   See the file COPYING for more details.                                *
 ***************************************************************************/


#ifndef ASPECT_MAINWINDOW_H
#define ASPECT_MAINWINDOW_H


#include "data.h"
#include "mcuserial.h"

#include <QDir>
#include <QSettings>
#include <QMainWindow>
#include <QList>
#include <QVector>

class QGraphicsScene;
class QStandardItem;
class QStandardItemModel;
class StatusBar;
class LogDialog;
class SettingsDialog;
class MountDialog;
class McuProxy;


namespace Ui { class MainWindow; };


class MainWindow: public QMainWindow
    {
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow();

public slots:
    void on_actionQuit_triggered();
    void on_actionAbout_Aspect_triggered();
    void on_actionAbout_Qt_triggered();

    void on_actionLog_View_triggered();
    void on_actionSettings_triggered();
    void on_actionMount_triggered();

    void settingsChanged();

    void mcuSerialStatus(bool bOpen, McuSerial::Status eStatus);
    void mcuSerialFirmware(const QString &qsFirmware);
    void mcuSerialBusy(bool bBusy);

    void on_mcuPort_activated(const QString &qsPort);
    void on_mcuSettingsTracking_activated(int nSpeed);
    void on_mcuSettingsPec_activated(int nIndex);
    void on_mcuSettingsIntelly_activated(int nIndex);
    void on_mcuSettingsRefresh_clicked();

    void on_actionOpen_PE_Data_triggered();
    void on_peFileFollow_clicked();
    void on_widgetPeMcu_dataPeChanged(IPeRawData *pData);
    void on_widgetPeIris_dataPeChanged(IPeRawData *pData);

    void on_peProcMode_activated(int nMode);
    void on_peProcBeg_valueChanged(int nBeg);
    void on_peProcEnd_valueChanged(int nEnd);
    void on_peProcCombining_activated(int nMethod);
    void on_peProcSmoothWidth_valueChanged(int nWidth);
    void on_peProcDrift_valueChanged(double dfDrift);
    void on_peProcDecl_valueChanged(double dfDeclination);
    void on_peProcScale_valueChanged(double dfScale);
    void on_peProcOffset_valueChanged(double dfOffset);

    void on_pecOpenTable_clicked();
    void on_pecSaveTable_clicked();
    void on_pecGetTable_clicked();
    void on_pecPutTable_clicked();
    void on_pecVerifyTable_clicked();
    void changePecItem(QStandardItem *pItem);
    void on_pecGenFirmware_activated(int nFirmware);
    void on_pecGenWormWheel_valueChanged(int nTeeth);
    void on_pecMountQuery_clicked();
    void on_pecCalculate_clicked();
    void on_pecGraphOffset_valueChanged(double dfOffset);

    void on_pecProfileOffset_valueChanged(double dfOffset);
    void on_pecProfileDrift_valueChanged(double dfDrift);
    void on_pecProfileOpen_clicked();
    void on_pecProfileSave_clicked();
    void on_mcuGuideEast_clicked();
    void on_mcuGuideWest_clicked();
    void on_mcuStart_clicked();
    void on_mcuPause_clicked();
    void mcuTimer();

    void on_toggleChartPeRaw_toggled(bool bOn);
    void on_toggleChartPeProcessed_toggled(bool bOn);
    void on_toggleChartPecIdeal_toggled(bool bOn);
    void on_toggleChartPecTable_toggled(bool bOn);
    void on_toggleChartPecProfile_toggled(bool bOn);

private:
    bool mcuCommunicationBegin();
    void mcuCommunicationEnd();

    bool openPeFile(const QString &qsFileName);

    bool openPecFile(const QString &qsFileName);
    bool savePecFile(const QString &qsFileName);
    void getPecTable();
    void putPecTable();
    void verifyPecTable();
    void calcPecParams();
    void calcPecTable();
    void fillPecModel();

    void clearPecProfile();
    bool startPecProfile(bool bSetSpeed);
    void stopPecProfile();
    bool openPecProfileFile(const QString &qsFileName);
    bool savePecProfileFile(const QString &qsFileName);

    void recalcPeData();
    void recalcPeChart();

private:
    Ui::MainWindow *m_pUi;
    StatusBar *m_pStatusBar;
    LogDialog *m_pLog;
    SettingsDialog *m_pSettings;
    MountDialog *m_pMount;
    IPeRawData *m_pPeRaw;
    QList<PePureSample> m_lstPePure;
    QList<PePureSample> m_lstPeSmoothed;
    QList<Period> m_lstPeriod;
    QVector<double> m_aPeProcessed;
    QVector<double> m_aPecIdeal;
    double m_dfSiderealDay;
    int m_nFirmware;
    int m_nWormWheelTeeth;
    double m_dfPecPosScale;
    PecData m_oPecTable;
    enum Dir { east, west, stop };
    Dir m_eGuideDir;
    QList<PeRawSample> m_lstPecProfile;
    QStandardItemModel *m_pPeProcessedModel;
    QStandardItemModel *m_pPecModel;
    QStandardItemModel *m_pPecProfileModel;
    QGraphicsScene *m_pPeChart;
    QTimer *m_pMcuTimer;
    QString m_qsSerialPort;
    McuProxy *m_pMcuProxy;
    };


#endif // ASPECT_MAINWINDOW_H

