
/***************************************************************************
 *   This file is part of Aspect, a simple PEC tool.                       *
 *                                                                         *
 *   Copyright (C) 2006-2007 by Wolfgang Hoffmann <woho@woho.de>           *
 *                                                                         *
 *   This program is free software, licensed under the GPL v2.             *
 *   See the file COPYING for more details.                                *
 ***************************************************************************/


#ifndef ASPECT_LOG_H
#define ASPECT_LOG_H

#include <QtCore>

#define LOG(a, b ...) do { if (a <= 2) { qDebug(b); Log::log(b); } } while (false)
#define DO_LOG(a) (a <= 2)
#define LOG_MCU(a ...) do { Log::mcu(a, QTime::currentTime()); } while (false)

//#define LQS(a) (a).toLocal8Bit().constData()
#define LQS(a) (a).toUtf8().constData()


class Log
    {
public:
    static void mcu(const QString &qsText, const QTime &oTime);
    static void log(const char *szFmt, ...)
#if 0 // don't; gives double compiler warnings as LOG() calls qDebug also
#if defined(Q_CC_GNU) && !defined(__INSURE__)
        __attribute__ ((format (printf, 1, 2)))
#endif
#endif
        ;
    static void startup();
    static void shutdown();
    };


class LogImpl: public QObject
    {
    Q_OBJECT

public:
    LogImpl(const QString &qsType);
    void append(const QString &qsText, const QTime &oTime = QTime::currentTime());
    void startup();
    void shutdown();
    static LogImpl g_oLog;
    static LogImpl g_oMcu;

private slots:
    void settingsChanged();
    void timeoutFlush();
    void timeoutClose();

private:
    QString m_qsType;
    QDir m_oPath;
    QFile *m_pFile;
    QTimer m_oTimerFlush;
    QTimer m_oTimerClose;
    bool m_bFirstStartup;
    bool m_bDoLog;
    bool m_bLineComplete;
    };


#endif // ASPECT_LOG_H


