
/***************************************************************************
 *   This file is part of Aspect, a simple PEC tool.                       *
 *                                                                         *
 *   Copyright (C) 2007 by Wolfgang Hoffmann <woho@woho.de>                *
 *                                                                         *
 *   This program is free software, licensed under the GPL v2.             *
 *   See the file COPYING for more details.                                *
 ***************************************************************************/


#ifndef ASPECT_DATAPEMCU_H
#define ASPECT_DATAPEMCU_H


#include "data.h"

#include <QFile>
#include <QList>
#include <QTimer>
#include <QWidget>

class QFileSystemWatcher;
class QStandardItem;
class QStandardItemModel;

namespace Ui { class DataPeMcu; };


class DataPeMcu: public QWidget, public IPeRawData
    {
    Q_OBJECT

public:
    DataPeMcu(QWidget *pParent = 0);
    ~DataPeMcu();

    void clearData();
    bool probePeFile(const QString &qsFileName) const;
    void setPeFileName(const QString &qsFileName);
    bool loadPeFile();
    bool pollPeFile(bool bOn);
    QList<PeRawSample> samples() const;

signals:
    void dataPeChanged(IPeRawData *pData);

private:
    bool openPeFile();
    void closePeFile();
    void clearPeData();

private slots:
    void readPeFile();
    void changePeItem(QStandardItem *pItem);

private:
    Ui::DataPeMcu *m_pUi;
    QFile m_oPeFile;
    QTimer m_oPoller;
    QString m_qsLineFragment;
    QList<PeRawSample> m_lstPeRaw;
    QStandardItemModel *m_pPeModel;
    bool m_bInModelRefill;
    };


#endif // ASPECT_DATAPEMCU_H

