
/***************************************************************************
 *   This file is part of Aspect, a simple PEC tool.                       *
 *                                                                         *
 *   Copyright (C) 2007 by Wolfgang Hoffmann <woho@woho.de>                *
 *                                                                         *
 *   This program is free software, licensed under the GPL v2.             *
 *   See the file COPYING for more details.                                *
 ***************************************************************************/


#ifndef ASPECT_DATAPEIRIS_H
#define ASPECT_DATAPEIRIS_H


#include "data.h"

#include <QFile>
#include <QList>
#include <QWidget>

class QStandardItem;
class QStandardItemModel;

namespace Ui { class DataPeIris; };


class PeIrisSample
    {
public:
    double m_dfTime;
    double m_dfStarPos;
    };


class DataPeIris: public QWidget, public IPeRawData
    {
    Q_OBJECT

public:
    DataPeIris(QWidget *pParent = 0);
    ~DataPeIris();

    void clearData();
    bool probePeFile(const QString &qsFileName) const;
    void setPeFileName(const QString &qsFileName);
    bool loadPeFile();
    bool pollPeFile(bool ) { return false; };
    QList<PeRawSample> samples() const;

    void setPixelScale(double dfScale);
    void setWormSync(double dfTime, int nWormPos);

signals:
    void dataPeChanged(IPeRawData *pData);

public slots:
    void on_aquiPixelScale_valueChanged(double dfScale);
    void on_wormTime_valueChanged(double dfTime);
    void on_wormPos_valueChanged(int nPosition);
    void on_wormSpeed_activated(int nSpeed);
    void on_wormGearTeeth_valueChanged(int nTeeth);
    void on_wormHemisphere_activated(int nHemisphere);
    void on_wormRotation_activated(int nRotation);

private slots:
    void changePeItem(QStandardItem *pItem);

private:
    void recalcPeRaw();

private:
    Ui::DataPeIris *m_pUi;
    QFile m_oPeFile;
    QList<PeIrisSample> m_lstPeIris;
    QList<PeRawSample> m_lstPeRaw;
    QStandardItemModel *m_pPeModel;
    };


#endif // ASPECT_DATAPEIRIS_H

