
/***************************************************************************
 *   This file is part of Aspect, a simple PEC tool.                       *
 *                                                                         *
 *   Copyright (C) 2007 by Wolfgang Hoffmann <woho@woho.de>                *
 *                                                                         *
 *   This program is free software, licensed under the GPL v2.             *
 *   See the file COPYING for more details.                                *
 ***************************************************************************/


#ifndef ASPECT_DATA_H
#define ASPECT_DATA_H


#include <QList>
#include <QString>
#include <QTime>
#include <QVector>


class IProgress
    {
public:
    virtual ~IProgress() {};
    virtual void setText(const QString &qsText) = 0;
    virtual bool setValue(double dfValue) = 0;
    };


class PeRawSample
    {
public:
    QTime m_oTime;
    double m_dfWorm;
    double m_dfRa;
    double m_dfDec;
    };


class IPeRawData
    {
public:
    virtual ~IPeRawData() {};
    virtual void clearData() = 0;
    virtual bool probePeFile(const QString &qsFileName) const = 0;
    virtual void setPeFileName(const QString &qsFileName) = 0;
    virtual bool loadPeFile() = 0;
    virtual bool pollPeFile(bool bOn) = 0;
    virtual QList<PeRawSample> samples() const = 0;
    };


class PePureSample
    {
public:
    double m_dfWorm;
    double m_dfPe;
    };


class Period
    {
public:
    int m_nRowBeg;
    int m_nRowEnd;
    double m_dfPeMin;
    double m_dfPeMax;
    };


class PecSample
    {
public:
    enum Val { keep = 0, faster = 1, slower = 2, reset = 3 };

    static int val2Int(Val eVal);
    static Val int2Val(int nVal);
    static int val2Acc(Val eVal);
    static Val acc2Val(int nAcc);

    PecSample();
    PecSample(Val eVal);
    PecSample(Val eVal, int nAcc, int nSpd, int nPos);

    Val m_eVal;
    int m_nAcc;
    int m_nSpd;
    int m_nPos;
    };

class PecData
    {
public:
    static const int c_nRowNum = 256;
    static const int c_nRowGen = 4;
    static const int c_nAggressNum = 15;
    static const int c_nFactorNum = 15;
    enum Traversal { forward = 1, backward = -1 };

    PecData();
    void clear();

    Traversal traversal() const;
    void setTraversal(Traversal eDirection);

    int factor() const;
    int aggress() const;
    int fileFactorAggress() const;
    const PecSample &operator[](int nRow) const;
    PecSample::Val value(int nRow) const;
    int valueInt(int nRow) const;
    bool set(int nFactor, int nAggress, const QVector<PecSample::Val> &aTable);
    bool setFactor(int nFactor);
    bool setAggress(int nAggress);
    bool setFileFactorAggress(int nFactorAggress);
    bool setValue(int nRow, PecSample::Val eVal);
    void setFinish();

    bool calc(const QVector<double> &aProfile, double dfPecPosScale,
        int nAggressMin, int nAggressMax, int nFactorMax, IProgress *pProgress);

private:
    void recalcGeo();

private:
    int m_nFactor;
    int m_nAggress;
    QVector<PecSample> m_aTable;
    Traversal m_eTraversal;
    int m_nOffset;
    };


#endif // ASPECT_DATA_H

