
/***************************************************************************
 *   This file is part of Aspect, a simple PEC tool.                       *
 *                                                                         *
 *   Copyright (C) 2006-2007 by Wolfgang Hoffmann <woho@woho.de>           *
 *                                                                         *
 *   This program is free software, licensed under the GPL v2.             *
 *   See the file COPYING for more details.                                *
 ***************************************************************************/


#ifndef ASPECT_CHART_H
#define ASPECT_CHART_H


#include <QGraphicsView>
#include <QPainterPath>

class QGraphicsScene;
class QGraphicsItem;


class Graph
    {
public:
    enum Style { dot, tick, line, stairLeft, stairRight };
    Graph(Style eStyle, double dfXBeg = 0., double dfXEnd = 256.,
        double dfYBeg = -1000., double dfYEnd = 1000.);
    void addData(double dfX, double dfY, bool bNewSubPath = false);
    void render(QGraphicsScene *pScene,
        double dfXScale, double dfYZero, double dfYScale,
        double dfZValue = 0., const QPen &oPen = QPen());
    double minX() const { return m_dfXMin; };
    double maxX() const { return m_dfXMax; };
    double minY() const { return m_dfYMin; };
    double maxY() const { return m_dfYMax; };
private:
    Style m_eStyle;
    double m_dfXBeg;
    double m_dfXEnd;
    double m_dfYBeg;
    double m_dfYEnd;
    double m_dfXMin;
    double m_dfXMax;
    double m_dfYMin;
    double m_dfYMax;
    bool m_bFirst;
    QPainterPath m_oPath;
    };


class Grid
    {
public:
    enum Lines { none = 0, minor = 1, major = 2, both = minor | major };
    enum Numbers { undec = 0, min = 1, max = 2, minmax = min | max };
    Grid();
    void addData(double dfX, double dfY);
    void addGraph(const Graph &oGraph);
    void render(QGraphicsScene *pScene,
        double dfXScale, double dfYZero, double dfYScale,
        Lines eLineX, Lines eLineY, Numbers eNumX, Numbers eNumY,
        double dfMajorX, double dfMinorX, double dfMajorY, double dfMinorY,
        double dfMajorZ = -1., double dfMinorZ = -2., const QColor &oNumberColor = Qt::black,
        const QPen &oMajorPen = QPen(Qt::gray), const QPen &oMinorPen = QPen(Qt::lightGray));
    double minX() const { return m_dfXMin; };
    double maxX() const { return m_dfXMax; };
    double minY() const { return m_dfYMin; };
    double maxY() const { return m_dfYMax; };
    double minYSanitized() const;
    double maxYSanitized() const;
private:
    double m_dfXMin;
    double m_dfXMax;
    double m_dfYMin;
    double m_dfYMax;
    };


class Chart: public QGraphicsView
    {
    Q_OBJECT

public:
    Chart(QWidget *pParent = 0);

    void clear();
    void requestSceneRender();

protected:
    void resizeEvent(QResizeEvent *pEvent);

private slots:
    void performSceneRender();

private:
    QTimer *m_pRenderTimer;
    bool m_bNeedSceneRender;
    };


#endif // ASPECT_CHART_H


